import React from 'react';
import { benefits } from '../mockData';
import { Battery, Smile, Heart, TrendingUp, Shield, Brain } from 'lucide-react';
import './BenefitsSection.css';

const iconMap = {
  Battery,
  Smile,
  Heart,
  TrendingUp,
  Shield,
  Brain
};

const BenefitsSection = () => {
  return (
    <section id="beneficios" className="benefits-section">
      <div className="container">
        <div className="section-header">
          <h2 className="heading-1">Beneficios del Balance Hormonal</h2>
          <p className="body-large section-subtitle">
            Descubre cómo el equilibrio hormonal transforma tu calidad de vida
          </p>
        </div>
        <div className="benefits-grid">
          {benefits.map((benefit) => {
            const IconComponent = iconMap[benefit.icon];
            return (
              <div key={benefit.id} className="benefit-card">
                <div className="benefit-icon-wrapper">
                  <IconComponent className="benefit-icon" size={28} />
                </div>
                <h3 className="heading-3 benefit-title">{benefit.title}</h3>
                <p className="body-medium benefit-description">{benefit.description}</p>
              </div>
            );
          })}
        </div>
      </div>
    </section>
  );
};

export default BenefitsSection;
