import React, { useState } from 'react';
import { clinicInfo } from '../mockData';
import { Button } from './ui/button';
import { Input } from './ui/input';
import { Label } from './ui/label';
import { Textarea } from './ui/textarea';
import { Card, CardContent, CardHeader, CardTitle } from './ui/card';
import { Phone, Mail, MapPin, Send } from 'lucide-react';
import './ContactSection.css';

const ContactSection = () => {
  const [formData, setFormData] = useState({
    name: '',
    email: '',
    phone: '',
    message: ''
  });

  const handleChange = (e) => {
    setFormData({
      ...formData,
      [e.target.name]: e.target.value
    });
  };

  const handleSubmit = (e) => {
    e.preventDefault();
    // Mock submission - will be connected to backend later
    console.log('Form submitted:', formData);
    alert('Gracias por contactarnos. Nos pondremos en contacto pronto.');
    setFormData({ name: '', email: '', phone: '', message: '' });
  };

  return (
    <section id="contacto" className="contact-section">
      <div className="container">
        <div className="section-header">
          <h2 className="heading-1">Contáctanos</h2>
          <p className="body-large section-subtitle">
            Estamos aquí para ayudarte a comenzar tu transformación
          </p>
        </div>
        <div className="contact-content">
          <div className="contact-info">
            <Card className="contact-info-card">
              <CardHeader>
                <CardTitle>Información de Contacto</CardTitle>
              </CardHeader>
              <CardContent className="contact-details">
                <div className="contact-item">
                  <div className="contact-icon-wrapper">
                    <Phone size={20} />
                  </div>
                  <div>
                    <div className="contact-label">Teléfono</div>
                    <a href={`tel:${clinicInfo.phone}`} className="contact-value">
                      {clinicInfo.phone}
                    </a>
                  </div>
                </div>
                <div className="contact-item">
                  <div className="contact-icon-wrapper">
                    <Mail size={20} />
                  </div>
                  <div>
                    <div className="contact-label">Email</div>
                    <a href={`mailto:${clinicInfo.email}`} className="contact-value">
                      {clinicInfo.email}
                    </a>
                  </div>
                </div>
                <div className="contact-item">
                  <div className="contact-icon-wrapper">
                    <MapPin size={20} />
                  </div>
                  <div>
                    <div className="contact-label">Dirección</div>
                    <div className="contact-value">{clinicInfo.address}</div>
                  </div>
                </div>
              </CardContent>
            </Card>
          </div>
          <div className="contact-form-wrapper">
            <Card className="contact-form-card">
              <CardHeader>
                <CardTitle>Enviar Mensaje</CardTitle>
              </CardHeader>
              <CardContent>
                <form onSubmit={handleSubmit} className="contact-form">
                  <div className="form-group">
                    <Label htmlFor="name">Nombre Completo</Label>
                    <Input
                      id="name"
                      name="name"
                      value={formData.name}
                      onChange={handleChange}
                      placeholder="Tu nombre"
                      required
                    />
                  </div>
                  <div className="form-group">
                    <Label htmlFor="email">Correo Electrónico</Label>
                    <Input
                      id="email"
                      name="email"
                      type="email"
                      value={formData.email}
                      onChange={handleChange}
                      placeholder="tu@email.com"
                      required
                    />
                  </div>
                  <div className="form-group">
                    <Label htmlFor="phone">Teléfono</Label>
                    <Input
                      id="phone"
                      name="phone"
                      type="tel"
                      value={formData.phone}
                      onChange={handleChange}
                      placeholder="+52 123 456 7890"
                      required
                    />
                  </div>
                  <div className="form-group">
                    <Label htmlFor="message">Mensaje</Label>
                    <Textarea
                      id="message"
                      name="message"
                      value={formData.message}
                      onChange={handleChange}
                      placeholder="Cuéntanos cómo podemos ayudarte..."
                      rows={5}
                      required
                    />
                  </div>
                  <Button type="submit" className="btn-primary w-full">
                    <Send size={18} />
                    Enviar Mensaje
                  </Button>
                </form>
              </CardContent>
            </Card>
          </div>
        </div>
      </div>
    </section>
  );
};

export default ContactSection;
