import React from 'react';
import { clinicInfo } from '../mockData';
import { Phone, Mail, MapPin, Heart } from 'lucide-react';
import './Footer.css';

const Footer = () => {
  const scrollToSection = (sectionId) => {
    const element = document.getElementById(sectionId);
    if (element) {
      element.scrollIntoView({ behavior: 'smooth', block: 'start' });
    }
  };

  return (
    <footer className="footer">
      <div className="container">
        <div className="footer-content">
          <div className="footer-section">
            <h3 className="footer-brand">{clinicInfo.name}</h3>
            <p className="footer-tagline">{clinicInfo.tagline}</p>
            <p className="footer-description">
              Especialistas en terapia de reemplazo hormonal bio-idéntica,
              comprometidos con tu salud y bienestar.
            </p>
          </div>

          <div className="footer-section">
            <h4 className="footer-title">Enlaces Rápidos</h4>
            <ul className="footer-links">
              <li>
                <button onClick={() => scrollToSection('servicios')} className="footer-link">
                  Servicios
                </button>
              </li>
              <li>
                <button onClick={() => scrollToSection('etapas')} className="footer-link">
                  Etapas de Vida
                </button>
              </li>
              <li>
                <button onClick={() => scrollToSection('beneficios')} className="footer-link">
                  Beneficios
                </button>
              </li>
              <li>
                <button onClick={() => scrollToSection('doctor')} className="footer-link">
                  Dr. M
                </button>
              </li>
              <li>
                <button onClick={() => scrollToSection('testimonios')} className="footer-link">
                  Testimonios
                </button>
              </li>
              <li>
                <button onClick={() => scrollToSection('faq')} className="footer-link">
                  Preguntas Frecuentes
                </button>
              </li>
            </ul>
          </div>

          <div className="footer-section">
            <h4 className="footer-title">Contacto</h4>
            <ul className="footer-contact">
              <li className="footer-contact-item">
                <Phone size={16} />
                <a href={`tel:${clinicInfo.phone}`}>{clinicInfo.phone}</a>
              </li>
              <li className="footer-contact-item">
                <Mail size={16} />
                <a href={`mailto:${clinicInfo.email}`}>{clinicInfo.email}</a>
              </li>
              <li className="footer-contact-item">
                <MapPin size={16} />
                <span>{clinicInfo.address}</span>
              </li>
            </ul>
          </div>
        </div>

        <div className="footer-bottom">
          <p className="footer-copyright">
            &copy; {new Date().getFullYear()} {clinicInfo.name}. Todos los derechos reservados.
          </p>
          <p className="footer-love">
            Hecho con <Heart size={14} fill="currentColor" className="heart-icon" /> para tu bienestar
          </p>
        </div>
      </div>
    </footer>
  );
};

export default Footer;
