import React from 'react';
import { lifestageInfo } from '../mockData';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from './ui/card';
import { Badge } from './ui/badge';
import './LifestagesSection.css';

const LifestagesSection = () => {
  return (
    <section id="etapas" className="lifestages-section">
      <div className="container">
        <div className="section-header">
          <h2 className="heading-1">Etapas de la Vida y Terapia Hormonal</h2>
          <p className="body-large section-subtitle">
            Tratamientos especializados para cada etapa de tu vida
          </p>
        </div>
        <div className="lifestages-grid">
          {lifestageInfo.map((stage) => (
            <Card key={stage.id} className="lifestage-card medical-card hover-lift">
              <CardHeader>
                <CardTitle className="heading-3">{stage.stage}</CardTitle>
                <CardDescription className="body-medium">
                  {stage.description}
                </CardDescription>
              </CardHeader>
              <CardContent>
                <div className="symptoms-section">
                  <h4 className="subsection-title">Síntomas Comunes:</h4>
                  <div className="symptoms-badges">
                    {stage.symptoms.map((symptom, index) => (
                      <Badge key={index} variant="secondary" className="symptom-badge">
                        {symptom}
                      </Badge>
                    ))}
                  </div>
                </div>
                <div className="treatment-section">
                  <h4 className="subsection-title">Tratamiento:</h4>
                  <p className="body-small treatment-text">{stage.treatment}</p>
                </div>
              </CardContent>
            </Card>
          ))}
        </div>
      </div>
    </section>
  );
};

export default LifestagesSection;
