import React from 'react';
import { testimonials } from '../mockData';
import { Card, CardContent } from './ui/card';
import { Star, Quote } from 'lucide-react';
import './TestimonialsSection.css';

const TestimonialsSection = () => {
  return (
    <section id="testimonios" className="testimonials-section">
      <div className="testimonials-bg-image"></div>
      <div className="container">
        <div className="section-header">
          <h2 className="heading-1">Lo Que Dicen Nuestros Pacientes</h2>
          <p className="body-large section-subtitle">
            Historias reales de transformación y bienestar
          </p>
        </div>
        <div className="testimonials-grid">
          {testimonials.map((testimonial) => (
            <Card key={testimonial.id} className="testimonial-card hover-lift">
              <CardContent className="testimonial-content">
                <div className="quote-icon-wrapper">
                  <Quote className="quote-icon" size={32} />
                </div>
                <div className="rating">
                  {[...Array(testimonial.rating)].map((_, i) => (
                    <Star key={i} className="star-icon" size={16} fill="currentColor" />
                  ))}
                </div>
                <p className="testimonial-text body-medium">"{testimonial.text}"</p>
                <div className="testimonial-author">
                  <div className="author-info">
                    <div className="author-name">{testimonial.name}</div>
                    <div className="author-meta">
                      {testimonial.age} años · {testimonial.condition}
                    </div>
                  </div>
                </div>
              </CardContent>
            </Card>
          ))}
        </div>
      </div>
    </section>
  );
};

export default TestimonialsSection;
