import React from 'react';
import { doctorInfo } from '../mockData';
import { Card, CardContent } from './ui/card';
import { Badge } from './ui/badge';
import { Award, Users, MapPin, CheckCircle } from 'lucide-react';
import './DoctorSection.css';

const DoctorSection = () => {
  return (
    <section id="doctor" className="doctor-section">
      <div className="container">
        <div className="section-header">
          <h2 className="heading-1">Nuestro Especialista</h2>
          <p className="body-large section-subtitle">
            Experiencia internacional al servicio de tu bienestar
          </p>
        </div>
        <div className="doctor-content">
          <div className="doctor-image-wrapper">
            <div className="doctor-image-placeholder">
              <img 
                src="https://customer-assets.emergentagent.com/job_bhrt-espanol/artifacts/8k0qfoyu_WhatsApp%20Image%202025-11-09%20at%209.23.27%20PM.jpeg"
                alt="Dr. M - Especialista en BHRT"
                className="doctor-image"
              />
            </div>
            <Card className="doctor-stats-card">
              <CardContent className="stats-content">
                <div className="stat-item">
                  <Users className="stat-icon" size={28} />
                  <div className="stat-text">
                    <div className="stat-number">Cientos</div>
                    <div className="stat-label">Pacientes Tratados</div>
                  </div>
                </div>
                <div className="stat-divider"></div>
                <div className="stat-item">
                  <Award className="stat-icon" size={28} />
                  <div className="stat-text">
                    <div className="stat-number">USA & Canadá</div>
                    <div className="stat-label">Certificado</div>
                  </div>
                </div>
              </CardContent>
            </Card>
          </div>
          
          <div className="doctor-info">
            <div className="doctor-header">
              <h3 className="heading-2">{doctorInfo.name}</h3>
              <p className="doctor-title">{doctorInfo.title}</p>
              <div className="doctor-badges">
                <Badge variant="secondary" className="doctor-badge">
                  <MapPin size={14} />
                  República Dominicana
                </Badge>
                <Badge variant="secondary" className="doctor-badge">
                  <Award size={14} />
                  {doctorInfo.certifications}
                </Badge>
              </div>
            </div>
            
            <div className="doctor-description">
              <p className="body-medium">{doctorInfo.description}</p>
            </div>
            
            <div className="doctor-expertise">
              <h4 className="expertise-title">Áreas de Especialización:</h4>
              <div className="expertise-grid">
                {doctorInfo.expertise.map((item, index) => (
                  <div key={index} className="expertise-item">
                    <CheckCircle className="check-icon" size={18} />
                    <span>{item}</span>
                  </div>
                ))}
              </div>
            </div>
            
            <div className="doctor-achievements">
              <h4 className="achievements-title">Logros Destacados:</h4>
              <ul className="achievements-list">
                {doctorInfo.achievements.map((achievement, index) => (
                  <li key={index} className="achievement-item">
                    {achievement}
                  </li>
                ))}
              </ul>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default DoctorSection;
