import React, { useState, useEffect } from 'react';
import { Button } from './ui/button';
import { clinicInfo } from '../mockData';
import { Phone, Menu, X } from 'lucide-react';
import './Header.css';

const Header = ({ onBookingClick }) => {
  const [isScrolled, setIsScrolled] = useState(false);
  const [isMobileMenuOpen, setIsMobileMenuOpen] = useState(false);

  useEffect(() => {
    const handleScroll = () => {
      setIsScrolled(window.scrollY > 50);
    };
    window.addEventListener('scroll', handleScroll);
    return () => window.removeEventListener('scroll', handleScroll);
  }, []);

  const scrollToSection = (sectionId) => {
    const element = document.getElementById(sectionId);
    if (element) {
      element.scrollIntoView({ behavior: 'smooth', block: 'start' });
      setIsMobileMenuOpen(false);
    }
  };

  return (
    <header className={`header-nav ${isScrolled ? 'scrolled' : ''}`}>
      <div className="container">
        <div className="header-content">
          <div className="logo-section">
            <h2 className="logo-text">{clinicInfo.name}</h2>
            <span className="logo-subtitle">Terapia Hormonal</span>
          </div>

          <nav className="desktop-nav">
            <button onClick={() => scrollToSection('servicios')} className="nav-link">
              Servicios
            </button>
            <button onClick={() => scrollToSection('etapas')} className="nav-link">
              Etapas de Vida
            </button>
            <button onClick={() => scrollToSection('beneficios')} className="nav-link">
              Beneficios
            </button>
            <button onClick={() => scrollToSection('doctor')} className="nav-link">
              Dr. M
            </button>
            <button onClick={() => scrollToSection('testimonios')} className="nav-link">
              Testimonios
            </button>
            <button onClick={() => scrollToSection('faq')} className="nav-link">
              FAQ
            </button>
            <button onClick={() => scrollToSection('contacto')} className="nav-link">
              Contacto
            </button>
          </nav>

          <div className="header-actions">
            <Button onClick={onBookingClick} className="btn-primary">
              <Phone size={18} />
              Agendar Cita
            </Button>
            <button
              className="mobile-menu-btn"
              onClick={() => setIsMobileMenuOpen(!isMobileMenuOpen)}
            >
              {isMobileMenuOpen ? <X size={24} /> : <Menu size={24} />}
            </button>
          </div>
        </div>

        {isMobileMenuOpen && (
          <div className="mobile-nav">
            <button onClick={() => scrollToSection('servicios')} className="mobile-nav-link">
              Servicios
            </button>
            <button onClick={() => scrollToSection('etapas')} className="mobile-nav-link">
              Etapas de Vida
            </button>
            <button onClick={() => scrollToSection('beneficios')} className="mobile-nav-link">
              Beneficios
            </button>
            <button onClick={() => scrollToSection('doctor')} className="mobile-nav-link">
              Dr. M
            </button>
            <button onClick={() => scrollToSection('testimonios')} className="mobile-nav-link">
              Testimonios
            </button>
            <button onClick={() => scrollToSection('faq')} className="mobile-nav-link">
              FAQ
            </button>
            <button onClick={() => scrollToSection('contacto')} className="mobile-nav-link">
              Contacto
            </button>
          </div>
        )}
      </div>
    </header>
  );
};

export default Header;
