import React from 'react';
import { Button } from './ui/button';
import { clinicInfo } from '../mockData';
import { Calendar, Shield, Award } from 'lucide-react';
import './HeroSection.css';

const HeroSection = ({ onBookingClick }) => {
  return (
    <section className="hero-section">
      <div className="hero-overlay"></div>
      <div className="container">
        <div className="hero-content">
          <div className="hero-badge">
            <Award size={16} />
            <span>Especialistas en Terapia Hormonal Bio-Idéntica</span>
          </div>
          <h1 className="heading-hero">
            Recupera Tu Vitalidad con <span className="text-accent">ReVive</span>
          </h1>
          <p className="hero-subtitle body-large">
            Terapia de Reemplazo Hormonal Bio-Idéntica personalizada para hombres y mujeres.
            Restaura tu energía, equilibrio y bienestar con tratamientos médicos profesionales.
          </p>
          <div className="hero-cta-group">
            <Button onClick={onBookingClick} className="btn-primary btn-large">
              <Calendar size={20} />
              Agendar Consulta Gratuita
            </Button>
            <a href="#servicios" className="btn-secondary btn-large">
              Ver Servicios
            </a>
          </div>
          <div className="hero-features">
            <div className="hero-feature-item">
              <Shield size={24} className="feature-icon" />
              <div>
                <div className="feature-title">Hormonas Bio-Idénticas</div>
                <div className="feature-subtitle">100% Naturales</div>
              </div>
            </div>
            <div className="hero-feature-item">
              <Award size={24} className="feature-icon" />
              <div>
                <div className="feature-title">Médicos Certificados</div>
                <div className="feature-subtitle">Experiencia Comprobada</div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default HeroSection;
