import React from 'react';
import { services } from '../mockData';
import { Activity, Heart, Moon, Zap, Target, TrendingUp, RefreshCw, Sparkles } from 'lucide-react';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from './ui/card';
import './ServicesSection.css';

const iconMap = {
  Activity,
  Heart,
  Moon,
  Zap,
  Target,
  TrendingUp,
  RefreshCw,
  Sparkles
};

const ServicesSection = () => {
  return (
    <section id="servicios" className="services-section">
      <div className="container">
        <div className="section-header">
          <h2 className="heading-1">Nuestros Servicios Especializados</h2>
          <p className="body-large section-subtitle">
            Tratamientos personalizados con hormonas bio-idénticas de la más alta calidad
          </p>
        </div>
        <div className="services-grid">
          {services.map((service) => {
            const IconComponent = iconMap[service.icon];
            return (
              <Card key={service.id} className="service-card medical-card hover-lift">
                <CardHeader>
                  <div className="service-icon-wrapper">
                    <IconComponent className="service-icon" size={32} />
                  </div>
                  <CardTitle className="heading-3">{service.title}</CardTitle>
                </CardHeader>
                <CardContent>
                  <CardDescription className="body-medium service-description">
                    {service.description}
                  </CardDescription>
                  <div className="benefits-list">
                    <h4 className="benefits-title">Beneficios:</h4>
                    <ul className="benefits-items">
                      {service.benefits.map((benefit, index) => (
                        <li key={index} className="benefit-item">
                          {benefit}
                        </li>
                      ))}
                    </ul>
                  </div>
                </CardContent>
              </Card>
            );
          })}
        </div>
      </div>
    </section>
  );
};

export default ServicesSection;
