// Mock data for ReVive Hormone Replacement Therapy Clinic

export const clinicInfo = {
  name: 'ReVive',
  tagline: 'Terapia de Reemplazo Hormonal Bio-Idéntica',
  phone: '+1 809 123 4567',
  email: 'contacto@revive.com',
  address: 'República Dominicana',
  whatsappNumber: '18091234567',
  whatsappMessage: 'Hola, me gustaría agendar una consulta para terapia hormonal con ReVive'
};

export const doctorInfo = {
  name: 'Dr. M',
  title: 'Especialista en Terapia Hormonal Bio-Idéntica',
  specialization: 'BHRT - Bio-Identical Hormone Replacement Therapy',
  certifications: 'Certificado en USA y Canadá',
  experience: 'Con cientos de pacientes tratados y vidas transformadas',
  description: 'El Dr. M es un profesional altamente calificado especializado en Terapia de Reemplazo Hormonal Bio-Idéntica (BHRT), con certificaciones en Estados Unidos y Canadá. Con una trayectoria destacada, ha tratado a cientos de pacientes, transformando sus vidas a través de tratamientos hormonales personalizados y basados en evidencia científica.',
  expertise: [
    'Terapia Hormonal Bio-Idéntica',
    'Manejo de Menopausia y Perimenopausia',
    'Optimización Hormonal Masculina',
    'Tratamiento de Hipotiroidismo',
    'Terapia para PCOS',
    'Medicina Preventiva y Anti-Envejecimiento'
  ],
  achievements: [
    'Cientos de pacientes tratados exitosamente',
    'Certificaciones internacionales en BHRT',
    'Experiencia en USA y Canadá',
    'Enfoque personalizado y basado en evidencia'
  ]
};

export const services = [
  {
    id: 1,
    title: 'Terapia de Reemplazo de Testosterona',
    description: 'Tratamiento personalizado para deficiencia de testosterona en hombres y mujeres. Mejora energía, masa muscular, líbido y bienestar general.',
    icon: 'Activity',
    benefits: ['Aumento de energía', 'Mejora de masa muscular', 'Mayor líbido', 'Mejor estado de ánimo']
  },
  {
    id: 2,
    title: 'Terapia de Estradiol',
    description: 'Balance hormonal con estradiol bio-idéntico para perimenopausia, menopausia y postmenopausia. Alivia sofocos, cambios de humor y mejora calidad de vida.',
    icon: 'Heart',
    benefits: ['Reduce sofocos', 'Mejora el sueño', 'Protege la salud ósea', 'Equilibrio emocional']
  },
  {
    id: 3,
    title: 'Terapia de Progesterona',
    description: 'Tratamiento con progesterona bio-idéntica para equilibrar el ciclo hormonal, mejorar el sueño y reducir ansiedad en mujeres.',
    icon: 'Moon',
    benefits: ['Mejora la calidad del sueño', 'Reduce ansiedad', 'Regula ciclo menstrual', 'Protección endometrial']
  },
  {
    id: 4,
    title: 'Terapia de DHEA',
    description: 'Optimización hormonal con DHEA para mejorar energía, sistema inmune, función cognitiva y bienestar general.',
    icon: 'Zap',
    benefits: ['Mayor energía vital', 'Fortalece sistema inmune', 'Mejora función cognitiva', 'Apoyo suprarrenal']
  },
  {
    id: 5,
    title: 'Tratamiento para PCOS',
    description: 'Terapia hormonal especializada para Síndrome de Ovario Poliquístico. Regula ciclos menstruales y mejora síntomas metabólicos.',
    icon: 'Target',
    benefits: ['Regula ciclos menstruales', 'Mejora fertilidad', 'Control de peso', 'Reducción de acné']
  },
  {
    id: 6,
    title: 'Tratamiento para Hipotiroidismo',
    description: 'Terapia hormonal tiroidea bio-idéntica para restaurar función metabólica, energía y bienestar general.',
    icon: 'TrendingUp',
    benefits: ['Restaura metabolismo', 'Aumenta energía', 'Mejora concentración', 'Control de peso']
  },
  {
    id: 7,
    title: 'Tratamiento para Hipogonadismo',
    description: 'Terapia de reemplazo hormonal para hipogonadismo en hombres y mujeres. Restaura función hormonal óptima.',
    icon: 'RefreshCw',
    benefits: ['Restaura función sexual', 'Mejora masa muscular', 'Aumenta densidad ósea', 'Mejor calidad de vida']
  },
  {
    id: 8,
    title: 'Tratamiento para Pérdida de Cabello',
    description: 'Terapia hormonal para detener la caída del cabello y promover el crecimiento. Tratamiento integral que aborda causas hormonales.',
    icon: 'Sparkles',
    benefits: ['Reduce caída de cabello', 'Promueve crecimiento', 'Fortalece folículos', 'Mejora densidad capilar']
  }
];

export const lifestageInfo = [
  {
    id: 1,
    stage: 'Perimenopausia',
    description: 'Etapa de transición antes de la menopausia con fluctuaciones hormonales. Síntomas incluyen ciclos irregulares, sofocos, cambios de humor.',
    symptoms: ['Ciclos irregulares', 'Sofocos', 'Cambios de humor', 'Insomnio', 'Sequedad vaginal'],
    treatment: 'Terapia hormonal bio-idéntica con estradiol y progesterona para equilibrar hormonas y aliviar síntomas.'
  },
  {
    id: 2,
    stage: 'Menopausia',
    description: 'Cese permanente de la menstruación después de 12 meses consecutivos sin periodo. Niveles hormonales disminuyen significativamente.',
    symptoms: ['Sofocos intensos', 'Sudores nocturnos', 'Sequedad vaginal', 'Pérdida de densidad ósea', 'Cambios cognitivos'],
    treatment: 'Terapia de reemplazo hormonal personalizada con estradiol, progesterona y DHEA para restaurar equilibrio.'
  },
  {
    id: 3,
    stage: 'Postmenopausia',
    description: 'Periodo después de la menopausia que continúa el resto de la vida. Requiere mantenimiento hormonal para salud óptima.',
    symptoms: ['Riesgo de osteoporosis', 'Cambios cardiovasculares', 'Pérdida de masa muscular', 'Cambios cognitivos'],
    treatment: 'Terapia de mantenimiento hormonal para proteger huesos, corazón, cerebro y mantener calidad de vida.'
  }
];

export const benefits = [
  {
    id: 1,
    title: 'Mejora de Energía y Vitalidad',
    description: 'El balance hormonal restaura niveles óptimos de energía, elimina fatiga crónica y mejora rendimiento físico y mental.',
    icon: 'Battery'
  },
  {
    id: 2,
    title: 'Equilibrio Emocional',
    description: 'Las hormonas equilibradas reducen ansiedad, depresión, cambios de humor e irritabilidad, mejorando bienestar emocional.',
    icon: 'Smile'
  },
  {
    id: 3,
    title: 'Salud Sexual Óptima',
    description: 'Restaura líbido, mejora función sexual, lubricación natural y satisfacción en la intimidad para hombres y mujeres.',
    icon: 'Heart'
  },
  {
    id: 4,
    title: 'Composición Corporal Saludable',
    description: 'Facilita pérdida de grasa, aumento de masa muscular, mejor metabolismo y mantenimiento de peso saludable.',
    icon: 'TrendingUp'
  },
  {
    id: 5,
    title: 'Protección Ósea y Cardiovascular',
    description: 'Las hormonas bio-idénticas protegen densidad ósea, reducen riesgo de osteoporosis y apoyan salud cardiovascular.',
    icon: 'Shield'
  },
  {
    id: 6,
    title: 'Mejora Cognitiva',
    description: 'Optimiza claridad mental, memoria, concentración y función cognitiva. Protege contra deterioro cognitivo.',
    icon: 'Brain'
  }
];

export const faqs = [
  {
    id: 1,
    question: '¿Qué son las hormonas bio-idénticas?',
    answer: 'Las hormonas bio-idénticas son hormonas que tienen la misma estructura molecular que las hormonas producidas naturalmente por el cuerpo humano. A diferencia de las hormonas sintéticas, las bio-idénticas son reconocidas y procesadas por el cuerpo de manera natural, resultando en mejor eficacia y menos efectos secundarios.'
  },
  {
    id: 2,
    question: '¿Es segura la terapia de reemplazo hormonal?',
    answer: 'Sí, cuando se administra correctamente bajo supervisión médica profesional. En ReVive utilizamos hormonas bio-idénticas de la más alta calidad, realizamos análisis completos antes de iniciar tratamiento y monitoreamos constantemente sus niveles hormonales para asegurar seguridad y eficacia óptima.'
  },
  {
    id: 3,
    question: '¿Cuánto tiempo tarda en hacer efecto el tratamiento?',
    answer: 'La mayoría de pacientes comienzan a notar mejoras en las primeras 2-4 semanas, con beneficios más significativos después de 3-6 meses. Cada persona es única y el tiempo de respuesta puede variar según su condición hormonal inicial y metabolismo individual.'
  },
  {
    id: 4,
    question: '¿La terapia hormonal es solo para mujeres?',
    answer: 'No, la terapia hormonal bio-idéntica beneficia tanto a hombres como a mujeres. Los hombres con deficiencia de testosterona, hipogonadismo o desequilibrios hormonales también experimentan mejoras significativas en energía, masa muscular, función sexual y bienestar general.'
  },
  {
    id: 5,
    question: '¿Necesito análisis de sangre antes de comenzar?',
    answer: 'Sí, en ReVive realizamos análisis hormonales completos antes de iniciar cualquier tratamiento. Esto nos permite diseñar un protocolo personalizado específico para sus necesidades y establecer una línea base para monitorear su progreso.'
  },
  {
    id: 6,
    question: '¿Cuáles son los efectos secundarios?',
    answer: 'Las hormonas bio-idénticas generalmente tienen menos efectos secundarios que las hormonas sintéticas. Algunos pacientes pueden experimentar ajustes menores iniciales como sensibilidad en senos o cambios en el estado de ánimo, que generalmente se resuelven con ajustes de dosis. Monitoreamos de cerca cada caso.'
  },
  {
    id: 7,
    question: '¿Por cuánto tiempo necesitaré el tratamiento?',
    answer: 'La duración del tratamiento varía según cada paciente. Algunos necesitan terapia a corto plazo para superar una transición hormonal específica, mientras que otros se benefician de mantenimiento a largo plazo. Evaluamos y ajustamos el plan de tratamiento regularmente según sus objetivos y respuesta.'
  }
];

export const testimonials = [
  {
    id: 1,
    name: 'María González',
    age: 48,
    condition: 'Menopausia',
    text: 'Después de meses de sofocos insoportables y noches sin dormir, ReVive cambió mi vida. En solo 6 semanas los sofocos desaparecieron casi por completo y volví a sentirme como yo misma. El equipo es profesional y atento.',
    rating: 5
  },
  {
    id: 2,
    name: 'Carlos Ramírez',
    age: 52,
    condition: 'Deficiencia de Testosterona',
    text: 'Había perdido toda mi energía y motivación. Gracias a la terapia de testosterona bio-idéntica en ReVive, recuperé mi vitalidad, mejoré en el gimnasio y mi relación con mi esposa es mejor que nunca. Totalmente recomendado.',
    rating: 5
  },
  {
    id: 3,
    name: 'Ana Patricia Ruiz',
    age: 35,
    condition: 'PCOS',
    text: 'Luché con PCOS durante años sin soluciones efectivas. El tratamiento hormonal personalizado de ReVive reguló mis ciclos, mejoró mi piel y finalmente pude concebir. Estoy eternamente agradecida con el equipo.',
    rating: 5
  },
  {
    id: 4,
    name: 'Roberto Sánchez',
    age: 45,
    condition: 'Hipotiroidismo',
    text: 'El cansancio extremo y aumento de peso me tenían deprimido. Con el tratamiento tiroideo de ReVive, mi metabolismo se normalizó, perdí 15 kilos y mi claridad mental regresó. Me siento 10 años más joven.',
    rating: 5
  }
];

export const adminUsers = [
  {
    id: 1,
    username: 'admin',
    password: 'revive2024', // In real app, this would be hashed
    role: 'admin'
  }
];
