import React, { useState } from 'react';
import Header from '../components/Header';
import HeroSection from '../components/HeroSection';
import ServicesSection from '../components/ServicesSection';
import LifestagesSection from '../components/LifestagesSection';
import BenefitsSection from '../components/BenefitsSection';
import DoctorSection from '../components/DoctorSection';
import FAQSection from '../components/FAQSection';
import TestimonialsSection from '../components/TestimonialsSection';
import ContactSection from '../components/ContactSection';
import Footer from '../components/Footer';
import BookingDialog from '../components/BookingDialog';

const HomePage = () => {
  const [isBookingOpen, setIsBookingOpen] = useState(false);

  return (
    <div className="home-page">
      <Header onBookingClick={() => setIsBookingOpen(true)} />
      <HeroSection onBookingClick={() => setIsBookingOpen(true)} />
      <ServicesSection />
      <LifestagesSection />
      <BenefitsSection />
      <DoctorSection />
      <TestimonialsSection />
      <FAQSection />
      <ContactSection />
      <Footer />
      <BookingDialog isOpen={isBookingOpen} onClose={() => setIsBookingOpen(false)} />
    </div>
  );
};

export default HomePage;
